<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Illuminate\Support\Facades\DB;

class transferNotification extends Notification
{
    use Queueable;

    /**
     * Create a new notification instance.
     */
    public $customer;
    public $balance;
    public $amount;

    public $wiretransfer;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($customer, $balance, $amount, $wiretransfer)
    {
        $this->customer = $customer;
        $this->balance = $balance;
        $this->amount = $amount;
        $this->wiretransfer = $wiretransfer;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
        ->subject(ucfirst(config('app.name')).' transfer alert for '.ucfirst($this->customer->firstname).' '.ucfirst($this->customer->lastname))
        ->line('Your '.ucfirst(config('app.name')).' Account, has been debited with '.$this->customer->currency.''.number_format($this->amount,2,'.','').' for a transfer.')
        ->line('Account name: '.ucfirst($this->customer->firstname).' '.ucfirst($this->customer->lastname))
        ->line('Account number: '.$this->customer->account_number)
        ->line('Balance: '.$this->customer->currency.''.number_format($this->balance,2,'.',''))

        ->line('Reciepient Bank: '.$this->wiretransfer->reciepient_bank)
        ->line('Reciepient account name: '.ucfirst($this->wiretransfer->reciepient_account_name).' ')
        ->line('Reciepient account number: '.$this->wiretransfer->reciepient_account_number)
        ->line('Reciepient address: '.$this->wiretransfer->address)

        ->line('Contact us immediately if you did not authorize this registration.')
        ->line('Thank you for choosing us.')
        ->line('Regards,')
        ->line('Team '. ucfirst(config('app.name')))
        ->action("Download Receipt", url('api/v1/customer/pdftransfer/'.$this->getTransaction()->uuid.'/'.$this->wiretransfer->id));
    }


    public function getTransaction() {
        $transaction = DB::table("transactions")->where("payable_id", $this->customer->id)->first();
        return $transaction;
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            //
        ];
    }
}
