<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class sendOtpTransfer extends Notification
{
    use Queueable;

    /**
     * Create a new notification instance.
     */
    public $customer;
    public $wiretransfer;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($customer, $wiretransfer)
    {
        $this->customer = $customer;
        $this->wiretransfer = $wiretransfer;
    }
    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
        ->subject('Wire transfer OTP for ' . config('app.name'))
        ->line("This email is being sent to you because a bank transfer is about to occur. Please find the OTP to validate the transaction below.")
        ->line('OTP: '.$this->wiretransfer->otp)
        ->line('Contact us immediately if you did not authorize this transaction.')
        ->line('Thank you for choosing us.')
        ->line('Regards,')
        ->line('Team '. ucfirst(config('app.name')));
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            //
        ];
    }
}
