<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class rejectkycNotification extends Notification
{
    use Queueable;

    public $customer;
    public $message;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($customer, $message)
    {
        $this->customer = $customer;
        $this->message = $message;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Your ' . config('app.name').' has been rejected')
            ->greeting('Hello '. $this->customer->firstname .' '. $this->customer->lastname)
            ->line($this->message)
            ->line('Contact us immediately if you did not authorize this registration.')
            ->line('Thank you for choosing us.')
            ->line('Regards,')
            ->line('Team '. ucfirst(config('app.name')));
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            //
        ];
    }
}
