<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('customer_invests', function (Blueprint $table) {
            $table->id();
            $table->string("investment_plans_id");
            $table->string("customer_id");
            $table->string("status")->default("pending");
            $table->string("amount");
            $table->timestamp("purchase_date")->nullable();
            $table->timestamp("maturity_date")->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('customer_invests');
    }
};
