<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('wire_transfers', function (Blueprint $table) {
            $table->id();
            $table->string('customer_id');
            $table->string('status')->default('intiated');
            $table->string('otp')->nullable();
            $table->string('account_number')->nullable();
            $table->string('account_type')->nullable();
            $table->string('reciepient_account_name')->nullable();
            $table->string('reciepient_account_number')->nullable();
            $table->string('reciepient_address')->nullable();
            $table->string('url')->nullable();
            $table->string('reciepient_bank')->nullable();
            $table->string('reciepient_bank_name')->nullable();
            $table->string('transaction_swift_number')->nullable();
            $table->string('transaction_transfer_amount')->nullable();
            $table->string('transaction_transfer_currency')->nullable();
            $table->string('transaction_transfer_description')->nullable();
            $table->string('transaction_transfer_type')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('wire_transfers');
    }
};
