<?php

namespace App\Models;

// use Illuminate\Auth\Authenticatable;

use App\Services\TransactionService;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use Laravel\Sanctum\Contracts\HasApiTokens;
use Tymon\JWTAuth\Contracts\JWTSubject;
use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Bavix\Wallet\Traits\HasWallet;
use Bavix\Wallet\Interfaces\Wallet;

class Customer extends Authenticatable implements JWTSubject, Wallet
{
    use HasFactory, Notifiable, HasWallet;
    protected $guarded = [];
    protected $appends = ['credit', 'debit', 'investmentbalance'];
    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    // protected $appends = ['userbalance'];

    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    /**
     * Return a key value array, containing any custom claims to be added to the JWT.
     *
     * @return array
     */
    public function getJWTCustomClaims()
    {
        return [];
    }

    // public function getUserbalanceAttribute()
    // {
    //     return $this->balance;
    //     // if ($value == null) {
    //     //     return null;
    //     // }
    //     // return json_decode($value)->accounts[0];
    // }

    public function getCreditAttribute()
    {
        $credit = DB::table('transactions')->where("type", "deposit")->where('payable_id', $this->id)->sum('amount');
        return $credit;
    }

    public function getDebitAttribute()
    {
        $debit = DB::table('transactions')->where("type", "withdraw")->where('payable_id', $this->id)->sum('amount');
        return $debit;
    }

    public function getInvestmentbalanceAttribute()
    {
        $debit = DB::table('investment_balances')->where("customer_id", $this->id)->sum('balance');
        return $debit;
    }

}
