<?php

use App\Http\Controllers\CustomerController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\WireTransferController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});


Route::group(['prefix' => 'v1'], function () {
    // Route::post('login',  [CustomerController::class, 'login']);
    Route::group([
        'prefix' => 'customer'
    ], function ($router) {
        Route::post('login', [CustomerController::class, 'login']);
        Route::post('create', [CustomerController::class, 'store']);
        Route::get('pdf-load/{id}',  [CustomerController::class, 'pdfLoad']);
        Route::get('pdftransfer/{id}/{wire}',  [CustomerController::class, 'pdfLoadWire']);
        Route::post('resetpassword',  [CustomerController::class, 'resetPassword']);
        Route::post('updateprofile',  [CustomerController::class, 'updateprofile']);
        Route::post('upload-img',  [CustomerController::class, 'uploadImg']);
        Route::post('upload-id-card',  [CustomerController::class, 'uploadIdcard']);
        Route::post('changepassword',  [CustomerController::class, 'changePassword']);
        // Route::post('send-phone-email',  [CustomerController::class, 'resentOtp']);
        // Route::post('update-profile',  [CustomerController::class, 'updateProfile']);
        // Route::post('verify-otp',  [CustomerController::class, 'verifyOtp']);
        Route::get('qrcode-generator',  [CustomerController::class, 'qrcodeGenerator']);
        Route::get('downliner',  [CustomerController::class, 'downliner']);
        Route::post('logout', [CustomerController::class, 'logout']);
        Route::post('refresh', [CustomerController::class, 'refresh']);
        Route::get('profile', [CustomerController::class, 'me']);
        Route::get('transactions/{id}', [CustomerController::class,'customerTransaction']);
        Route::prefix('monify')->group(function () {
            Route::post('verify', [CustomerController::class, 'verifyPayment']);
        });

        Route::group(['prefix' => 'wire-transfer'], function () {
            Route::get('list', [WireTransferController::class, 'index']);
            Route::post('create', [WireTransferController::class, 'store']);
            Route::post('otp', [WireTransferController::class, 'enterOtp']);
        });

        Route::group([
            'prefix' => 'investment'
        ], function ($router) {
            Route::get('wallet-address-list',  [CustomerController::class, 'walletAddressList']);
            Route::get('investment-image-list-customer',  [CustomerController::class, 'investmentImageListCustomer']);
            Route::post('credit-investment-image',  [CustomerController::class, 'creditInvestmentImage']);
            Route::get('investment-plan-list',  [CustomerController::class, 'investmentPlan']);
            Route::post('credit-investment-now',  [CustomerController::class, 'customerInvestNow']);
            Route::post('withdraw-investment',  [CustomerController::class, 'withdrawFromPlan']);
            Route::get('customer-active-investment-plan',  [CustomerController::class, 'listactiveCustomerInvestment']);
        });

    });


    Route::group([
        'prefix' => 'admin'
    ], function ($router) {
        Route::post('login',  [AdminController::class, 'login']);
        Route::post('logout', [AdminController::class, 'logout']);
        Route::post('refresh', [AdminController::class, 'refresh']);
        Route::get('profile', [AdminController::class, 'me']);
        Route::post('mark-id-card',  [AdminController::class, 'markIdcard']);
        Route::post('reject-id-card',  [AdminController::class, 'rejectIdcard']);

        Route::group([
            'prefix' => 'investment'
        ], function ($router) {
            Route::get('wallet-address-list',  [AdminController::class, 'walletAddressList']);
            Route::post('add-wallet-address',  [AdminController::class, 'addWalletAddress']);
            Route::post('credit-investment-balance',  [AdminController::class, 'creditInvestment']);
            Route::get('investment-image-list',  [AdminController::class, 'investmentImageList']);
            Route::post('credit-investment-wallet',  [AdminController::class, 'creditInvestmentWallet']);


            Route::get('investment-plan-list',  [AdminController::class, 'investmentPlan']);
            Route::post('create-investment-plan',  [AdminController::class, 'createInvestmentPlan']);
            Route::post('delete-investment-plan/{investmentPlan}',  [AdminController::class, 'deleteInvestmentPlan']);
            Route::put('update-investment-plan/{investmentPlan}',  [AdminController::class, 'updateInvestmentPlan']);
        });

        Route::group([
            'prefix' => 'customer'
        ], function ($router) {
            Route::get('list',  [AdminController::class, 'indexCustomer']);
            Route::get('show/{id}',  [AdminController::class, 'showCustomer']);
            Route::get('transaction/{id}',  [AdminController::class, 'customerTransaction']);
            Route::get('wire-transaction/{id}',  [AdminController::class, 'customerWireTransfer']);
            Route::get('investment-wallet-transaction/{id}',  [AdminController::class, 'customerInvestmentWalletTransaction']);
            Route::get('delete-wire-transaction/{id}',  [AdminController::class, 'deleteWireTransfer']);
            Route::get('delete-transaction/{id}',  [AdminController::class, 'deleteCustomerTransaction']);
            Route::post('credit',  [AdminController::class, 'creditCustomer']);
            Route::post('debit',  [AdminController::class, 'debitCustomer']);
            Route::post('block',  [AdminController::class, 'blockAccount']);
            Route::post('unblock',  [AdminController::class, 'unblockAccount']);
            Route::post('backdate',  [AdminController::class, 'wireDataObj']);
            Route::post('transaction/backdate',  [AdminController::class, 'updateCreatedAtTransaction']);
            Route::post('update-transactions',  [AdminController::class, 'updateTransactions']);
        });
    });


});
