<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;

class CustomerInvest extends Model
{
    use HasFactory;
    protected $table = "customer_invests";

    protected $guarded = [];

    protected $appends = ['customer', 'investment', 'daysdiff', 'withdrawable'];

    public function getCustomerAttribute()
    {
        $debit = Customer::where("id", $this->customer_id)->first();
        return $debit;
    }

    public function getInvestmentAttribute()
    {
        $debit = InvestmentPlan::where("id", $this->investment_plans_id)->first();
        return $debit;
    }

    public function getDaysdiffAttribute() {
        $date1 = Carbon::createFromFormat('Y-m-d H:i:s', $this->purchase_date);
        $date2 = Carbon::createFromFormat('Y-m-d H:i:s', $this->maturity_date);
        $dfromnow = $date1->diffInDays(Carbon::now());
        $dayDifference = $date1->diffInDays($date2);
        logs()->info($dfromnow);
        logs()->info($dayDifference);
        // logs()->info((($dayDifference - $dfromnow)/$dayDifference) * 100);
        if($dfromnow == 0) {
            return 0;
        }
        return number_format(100 - ((($dayDifference - $dfromnow)/$dayDifference) * 100));
    }

    public function getWithdrawableAttribute() {
        // $date1 = Carbon::createFromFormat('Y-m-d H:i:s', $this->purchase_date);
        // $date2 = Carbon::createFromFormat('Y-m-d H:i:s', $this->maturity_date);
        // $dfromnow = $date1->diffInDays(Carbon::now());
        // $dayDifference = $date1->diffInDays($date2);
        // logs()->info($dfromnow);
        // logs()->info($dayDifference);
        // // logs()->info((($dayDifference - $dfromnow)/$dayDifference) * 100);
        // if($dfromnow == 0) {
        //     return 0;
        // }
        // return (($dayDifference - $dfromnow)/$dayDifference) * 100;

        $date1 = Carbon::createFromFormat('Y-m-d H:i:s', $this->purchase_date);
        $date2 = Carbon::createFromFormat('Y-m-d H:i:s', $this->maturity_date);
        $dfromnow = $date1->diffInDays(Carbon::now());
        $dayDifference = $date1->diffInDays($date2);
        logs()->info($dfromnow);
        logs()->info($dayDifference);
        // logs()->info((($dayDifference - $dfromnow)/$dayDifference) * 100);
        if($dfromnow == 0) {
            return 0;
        }
        $investmentdays = (($dayDifference - $dfromnow)/$dayDifference) * 100;
        $investment = InvestmentPlan::where("id", $this->investment_plans_id)->first();

        $profitable = $this->amount * ($investment->percent /100);

        return ($profitable * ($investmentdays/100));
        // return 0;
        // $coveredpercent = $investment->daysdiff;
        // $profitable = $investment->amount * ($investment->percent /100);
        // $withdrawableamount = $profitable * ($coveredpercent/100);
        // return $withdrawableamount;
    }

}
