<?php

namespace App\Http\Controllers;

use App\Models\Customer;
use App\Models\WireTransfer;
use App\Notifications\creditNotification;
use App\Notifications\debitNotification;
use App\Notifications\sendOtpTransfer;
use App\Notifications\transferNotification;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class WireTransferController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $wiretransfer = WireTransfer::whereNotNull("wire_transfers.id")->where("customer_id",  auth("customers")->user()->id)->latest();
        $request->status  != null  ? $wiretransfer->where("status",$request->status) : $wiretransfer;
        $wiretransfer = $request->page_number != null ? $wiretransfer->paginate($request->page_number) : $wiretransfer->get();
        return response()->json(["message" => "successful", "wiretransfer" => $wiretransfer], 200);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            "account_number" => "required",
            "account_type" => "required",
            "reciepient_account_name" => "required",
            "reciepient_account_number" => "required",
            "reciepient_bank" => "required",
            "reciepient_address" => "required",
            "reciepient_bank_name" => "required",
            "transaction_swift_number" => "required",
            "transaction_transfer_amount" => "required",
            "transaction_transfer_currency" => "required",
            "transaction_transfer_description" => "required",
            "transaction_transfer_type" => "required",
        ]);

        $customer = auth("customers")->user();

        // $customer->balance
        if ($customer->balance < $request->amount) {
            return response()->json(["message" => "Balance is low"], 400);
        }

        if ($request->transaction_transfer_type == "Domestic Transfer") {
            $reciepient_account = Customer::where("account_number", $request->reciepient_account_number)->first();
            // if ($reciepient_account == null || $reciepient_account->account_number == auth("customers")->user()->account_number) {
            //     return response()->json(["message" => "Wrong Account Number."], 400);
            // }
        }

        $wireTransfer =  WireTransfer::create([
            "customer_id" => auth('customers')->user()->id,
            "status" =>  "intiated",
            "otp" => rand(100000,999999),
            "account_number" => $request->account_number,
            "account_type" => $request->account_type,
            "reciepient_account_name" => $request->reciepient_account_name,
            "reciepient_account_number" => $request->reciepient_account_number,
            "reciepient_address" => $request->reciepient_address,
            "reciepient_bank_name" => $request->reciepient_bank_name,
            "transaction_swift_number" => $request->transaction_swift_number,
            "transaction_transfer_amount" => $request->transaction_transfer_amount,
            "transaction_transfer_currency" => $request->transaction_transfer_currency,
            "transaction_transfer_description" => $request->transaction_transfer_description,
            "transaction_transfer_type" => $request->transaction_transfer_type,
            "reciepient_bank" => $request->reciepient_bank
        ]);

        $customer->notify(new sendOtpTransfer($customer, $wireTransfer));
        return response()->json([
            "message" => "Wire Transfer Created Successfully.",
            "wire_transfer" => $wireTransfer
        ], 200);
    }

    public function enterOtp(Request $request)
    {
        $request->validate([
            "otp" => "required|string",
            "wire_transfer_id" => "required",
        ]);
        $wiretransfer = WireTransfer::where("id", $request->wire_transfer_id)->first();
        if ($wiretransfer == null) {
            return response()->json([
                "message" => "Not found",
            ], 400);
        }
        $customer = auth("customers")->user();

        $reciepient_account = Customer::where("account_number", $wiretransfer->reciepient_account_number)->first();
        // return $reciepient_account;
        if ($wiretransfer->transaction_transfer_type == "Domestic Transfer") {
            // if ($reciepient_account != null) {
            //     $reciepient_account->deposit($wiretransfer->transaction_transfer_amount);
            //     $reciepient_account->notify(new creditNotification($customer,$customer->balanceInt, $wiretransfer->transaction_transfer_amount));
            //     // return response()->json(["message" => "Wrong Account Number."], 400);
            // }

        }
        $customer->withdraw($wiretransfer->transaction_transfer_amount,['description' => $wiretransfer->transaction_transfer_description]);
        $customer->notify(new transferNotification($customer,$customer->balanceInt, $wiretransfer->transaction_transfer_amount, $wiretransfer));


        $url = url('api/v1/customer/pdftransfer/'.$this->getTransaction($customer)->uuid.'/'.$wiretransfer->id);
        if ($wiretransfer->otp == $request->otp) {
            $wiretransfer->update([
                "status" => "completed",
                "url" => $url
            ]);
            return response()->json([
                "message"=> "Transfer Successful",
            ], 200);
        }
        return response()->json([
            "message" => "Wrong OTP",
        ], 400);
    }


    public function getTransaction($customer) {
        $transaction = DB::table("transactions")->where("payable_id", $customer->id)->first();
        return $transaction;
    }

    /**
     * Display the specified resource.
     */
    public function show(WireTransfer $wireTransfer)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(WireTransfer $wireTransfer)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, WireTransfer $wireTransfer)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(WireTransfer $wireTransfer)
    {
        //
    }
}
