<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Laravel 7 PDF Example</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.0/css/bootstrap.min.css">
    <link href="<?php echo e(asset('css/app.css')); ?>" rel="stylesheet" type="text/css" />
</head>
<body>
    <div class="container mt-5">
        <h2 class="text-center mb-3">Green Field Verdant Transaction</h2>
        
        <table class="table table-bordered mb-5">
            <thead>
                <tr>
                    <td colspan="2" style="text-align: center;">
                        <img src="<?php echo e(public_path('assets/RFBco.png')); ?>" class="logo" alt="Green Field Verdant">
                    </td>
                </tr>
                <tr class="">
                    <th scope="col">Account Name</th>
                    <th scope="col"><?php echo e(ucfirst($customer->firstname)); ?> <?php echo e(ucfirst($customer->lastname)); ?></th>
                </tr>
                <tr class="">
                    <th scope="col">Account Number</th>
                    <th scope="col"><?php echo e($customer->account_number); ?></th>
                </tr>
                <tr class="">
                    <th scope="col">Type</th>
                    <th scope="col"><?php echo e(ucfirst($transact->type)); ?></th>
                </tr>
                <tr class="">
                    <th scope="col">Amount</th>
                    <th scope="col"><?php echo e($customer->currency); ?> <?php echo e(number_format($transact->amount)); ?></th>
                </tr>

                <tr class="">
                    <th scope="col">Balance</th>
                    <th scope="col"><?php echo e($customer->currency); ?> <?php echo e(number_format($balance)); ?></th>
                </tr>
                <tr class="">
                    <th scope="col">Date Time</th>
                    <th scope="col"><?php echo e(date('d-m-Y h:i:s', strtotime($transact->created_at))); ?></th>
                </tr>

            </thead>
            
        </table>
        <p>Thank your for using <?php echo e(config("app.name")); ?> remember we will never ask you for you account number and password. </p>
    </div>
    <script src="<?php echo e(asset('js/app.js')); ?>" type="text/js"></script>
</body>
</html>
<?php /**PATH /home/u644730869/domains/backend.greenfieldverdant.com/public_html/resources/views/employee.blade.php ENDPATH**/ ?>