<?php

namespace App\Http\Controllers;

use App\Models\Admin;
use App\Models\Customer;
use App\Models\InvestmentPaymentWalletAddress;
use App\Models\Transaction;
use App\Models\WireTransfer;
use App\Notifications\creditNotification;
use App\Notifications\debitNotification;
use App\Notifications\creditInvestmentWalletNotification;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Notifications\approvekycNotification;
use App\Notifications\rejectkycNotification;
use App\Models\InvestmentBalance;
use App\Models\CustomerInvest;
use App\Models\InvestmentBalanceTransaction;
use App\Models\InvestmentBalanceTransactionRequest;
use App\Models\InvestmentPlan;

class AdminController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:admins', ['except' => ['login']]);
    }
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    public function markIdcard(Request  $request) {
        $request->validate(["id_card_upload" => "required|string", "customer_id" => "required"]);
        $customer = Customer::where("id", $request->customer_id)->first();
        if ($customer == null) {
            return response()->json(["message" => "Customer not found."], 400);
        }

        if ($customer->id_card_upload == null) {
            return response()->json(["message" => "Customer verification not required now."], 400);
        }
        $customer->update(["id_card" => $request->id_card_upload, "id_card_upload" => null]);

        try {
            $customer->notify(new approvekycNotification($customer,"Your Kyc was approved successfully."));
        } catch (\Throwable $th) {
            //throw $th;
        }
        return response()->json(["message" => "Successfully"], 200);
    }

    public function creditInvestmentWallet(Request $request) {
        $request->validate([
            "amount" => "required|string",
            "customer_id" => "required|string",
        ]);
        $customer = Customer::where("id", $request->customer_id)->first();
        $investmentBalance = InvestmentBalance::where(["customer_id" => $customer->id])->first();
        $newbalance = $investmentBalance->balance + $request->amount;
        $investmentBalance->update([
            "balance" => $newbalance
        ]);
        InvestmentBalanceTransaction::create([
            "type" => "credit",
            "amount" => $request->amount,
            "customer_id" => $request->customer_id
        ]);
        $customer->notify(new creditInvestmentWalletNotification($customer,$investmentBalance->balance, $request->amount));
        return response()->json(["message" => "Credit successful"], 200);
    }


    public function creditInvestment(Request $request) {
        $request->validate([
            "amount" => "required|string",
            "customer_id" => "required|string",
            "funding_investment_wallet_id" => "required"
        ]);
        $funding_investment_wallet_id = InvestmentBalanceTransactionRequest::where("id", $request->funding_investment_wallet_id)->first();
        $customer = Customer::where("id", $request->customer_id)->first();
        $investmentBalance = InvestmentBalance::where(["customer_id" => $customer->id])->first();
        $newbalance = $investmentBalance->balance + $request->amount;
        $investmentBalance->update([
            "balance" => $newbalance
        ]);

        InvestmentBalanceTransaction::create([
            "type" => "credit",
            "amount" => $request->amount,
            "customer_id" => $request->customer_id
        ]);

        $funding_investment_wallet_id->update([
            "status" => "confirmed"
        ]);

        $customer->notify(new creditInvestmentWalletNotification($customer,$investmentBalance->balance, $request->amount));

        return response()->json(["message" => "Credit successful"], 200);
    }

    public function investmentImageList() {
        $investmentImage = InvestmentBalanceTransactionRequest::latest()->get();
        return response()->json(["message" => "success", "data" => $investmentImage], 200);
    }

    public function walletAddressList() {
        $dd = InvestmentPaymentWalletAddress::latest()->get();
        return response()->json(["message" => "Created", "data" => $dd], 200);
    }

    public function addWalletAddress(Request $request) {
        $request->validate([
            "type" => "required|string",
            "address" => "required|string",
        ]);
        $investmentPaymentWalletAddress = InvestmentPaymentWalletAddress::create([
            "type" => $request->type,
            "address" => $request->address
        ]);

        return response()->json(["message" => "Created", "data" => $investmentPaymentWalletAddress], 200);
        // InvestmentPaymentWalletAddress
    }

    public function rejectIdcard(Request  $request) {
        $request->validate(["id_card_upload" => "required|string", "customer_id" => "required"]);
        $customer = Customer::where("id", $request->customer_id)->first();
        if ($customer == null) {
            return response()->json(["message" => "Customer not found."], 400);
        }

        if ($customer->id_card_upload == null) {
            return response()->json(["message" => "Customer verification not required now."], 400);
        }
        $customer->update(["id_card" => null, "id_card_upload" => null]);
        try {
            $customer->notify(new rejectkycNotification($customer,"Your Kyc was rejected successfully."));
        } catch (\Throwable $th) {
            //throw $th;
        }
        return response()->json(["message" => "Successfully"], 200);
    }

    public function indexCustomer()
    {
        $customers = Customer::get();
        foreach ($customers as $value) {
            $value->balanceInt;
        }
        return  response()->json(["message" => "successful", "customers" => $customers], 200);
    }

    public function showCustomer($id) {
        $customer = Customer::where("id", $id)->first();
        if (!$customer) {
            return response()->json(["message"=> "No customer"],400);
        }
        $customer->balanceInt;
        return response()->json(["message"=> "Credited Successfully.", "customer" => $customer],200);
    }

    public function creditCustomer(Request $request) {
        $request->validate([
            "amount" => "required",
            "customer_id" => "required"
        ]);
        $customer = Customer::where("id", $request->customer_id)->first();
        if (!$customer) {
            return response()->json(["message"=> "No customer"],400);
        }
        $customer->deposit($request->amount);
        $customer->notify(new creditNotification($customer,$customer->balanceInt, $request->amount));
        return response()->json(["message"=> "Credited Successfully."],200);
    }

    public function debitCustomer(Request $request) {
        $request->validate([
            "amount" => "required",
            "customer_id" => "required",
            "message" => "required"
        ]);
        $customer = Customer::where("id", $request->customer_id)->first();
        if (!$customer) {
            return response()->json(["message"=> "No customer"],400);
        }
        if ($customer->balance < $request->amount) {
            return response()->json(["message"=> "Low Balance"],400);
        }
        $customer->withdraw($request->amount,['description' => $request->message]);
        $customer->notify(new debitNotification($customer,$customer->balanceInt, $request->amount));
        return response()->json(["message"=> "Credited Successfully."],200);
    }

    public function wireDataObj(Request $request) {
        $request->validate(["datetime" => "required|string", "id" => "required"]);
        // $wiretransfer = DB::table("wire_transfers")->where("id", $request->id)->first();
        $wiretransfer = WireTransfer::where("id", $request->id)->first();
        $wiretransfer->update(["created_at" => $request->datetime]);
        return response()->json(["message"=> "Credited Successfully.","wiretransfer" => $wiretransfer],200);
    }

    public function updateCreatedAtTransaction(Request $request) {
        $request->validate(["datetime" => "required|string", "id" => "required"]);
        // $wiretransfer = DB::table("wire_transfers")->where("id", $request->id)->first();
        $wiretransfer = DB::table("transactions")->where("uuid", $request->id)->first();
        // return $wiretransfer;
        $wiretransfer->update(["created_at" => $request->datetime]);
        return response()->json(["message"=> "Credited Successfully.","wiretransfer" => $wiretransfer],200);
    }

    public function updateTransactions(Request $request) {
        $request->validate(["datetime" => "required|string", "id" => "required"]);
        $transaction = Transaction::where("uuid", $request->id)->first();
        $transaction->update(["created_at" => $request->datetime]);
        return response()->json(["message"=> "Credited Successfully.","wiretransfer" => $transaction],200);
    }
    public function blockAccount(Request $request) {
        $request->validate([
            "customer_id" => "required",
            "message" => "required"
        ]);
        $customer = Customer::where("id", $request->customer_id)->first();
        if (!$customer) {
            return response()->json(["message"=> "No customer"],400);
        }
        $customer->update([
            "status" => "disabled"
        ]);

        return response()->json(["message"=> "Successfully."],200);
    }

    public function unblockAccount(Request $request) {
        $request->validate([
            "customer_id" => "required",
            "message" => "required"
        ]);
        $customer = Customer::where("id", $request->customer_id)->first();
        if (!$customer) {
            return response()->json(["message"=> "No customer"],400);
        }
        $customer->update([
            "status" => "active"
        ]);
        return response()->json(["message"=> "Successfully."],200);
    }

    public function customerTransaction($id) {
        $transctions = DB::table('transactions')->where("payable_id", $id)->latest()->get();
        return response()->json(["message" => "Success", "transctions"=> $transctions],200);
    }

    public function deleteCustomerTransaction($id) {
        $transctions = DB::table('transactions')->where("id", $id)->delete();
        return response()->json(["message" => "Deleted Success"],200);
    }

    public function customerWireTransfer($id) {
        $transctions = DB::table('wire_transfers')->where("customer_id", $id)->latest()->get();
        return response()->json(["message" => "Success", "wire_transfers"=> $transctions],200);
    }

    public function customerInvestmentWalletTransaction($id) {
        $transctions = DB::table('investment_balance_transactions')->where("customer_id", $id)->latest()->get();
        return response()->json(["message" => "Success", "wire_transfers"=> $transctions],200);
    }


    public function deleteWireTransfer($id) {
        $transctions = DB::table('wire_transfers')->where("id", $id)->delete();
        return response()->json(["message" => "Deleted Success"],200);
    }

    public function login(Request $request)
    {
        $credentials = request(['email', 'password']);

        if (! $token = auth("admins")->attempt($credentials)) {
            return response()->json(["message" => 'Incorrect admin combination.'], 400);
        }
        $customer = Admin::where('email', $request->email)->first();
        $token = auth('admins')->login($customer);
        return response()->json([
            "message" => "Successfully.",
            "customer" => $customer,
            'access_token' => $token,
            'token_type' => 'bearer',
            'expires_in' => auth("admins")->factory()->getTTL() * 60
        ]);

        // return $this->respondWithToken($token);
    }

    /**
     * Get the authenticated User.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function me()
    {   auth("admins")->user()->balanceInt;
        return response()->json(["admin" => auth("admins")->user()]);
    }

    public function logout()
    {
        auth()->logout();

        return response()->json(['message' => 'Successfully logged out']);
    }

    /**
     * Refresh a token.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function refresh()
    {
        return $this->respondWithToken(auth("admins")->refresh());
    }

    /**
     * Get the token array structure.
     *
     * @param  string $token
     *
     * @return \Illuminate\Http\JsonResponse
     */
    protected function respondWithToken($token)
    {
        return response()->json([
            'access_token' => $token,
            'token_type' => 'bearer',
            'expires_in' => auth("admins")->factory()->getTTL() * 60
        ]);
    }



    /**
     * Display the specified resource.
     */
    public function show(Admin $admin)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Admin $admin)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Admin $admin)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Admin $admin)
    {
        //
    }

    public function investmentPlan() {
        $dd = InvestmentPlan::latest()->get();
        return response()->json(['message' => 'Successfully', 'data' => $dd], 200);
    }

    public function deleteInvestmentPlan(InvestmentPlan $investmentPlan) {
        $customerPlan = CustomerInvest::where("investment_plans_id", $investmentPlan->id)->first();
        if ($customerPlan != null) {
            return response()->json(['message' => 'Already in use', 'data' => ""], 200);
        }
        $dd = InvestmentPlan::latest()->where("id", $investmentPlan->id)->first()->delete();
        return response()->json(['message' => 'Successfully deleted', 'data' => $dd], 200);
    }

    public function createInvestmentPlan(Request $request) {
        $request->validate([
            "name" => "required|string",
            "amount" => "required|string",
            "percent" => "required|string",
            "duration_in_days" => "required|string",
            "min_deposit" => "required|string",
            "max_deposit" => "required|string",
        ]);
        $data = $request->all();
        $dd = InvestmentPlan::create([
            "name" => $request->name,
            "amount" => $request->amount,
            "percent" => $request->percent,
            "duration_in_days" => $request->duration_in_days,
            "min_deposit" => trim($request->min_deposit),
            "max_deposit" => trim($request->max_deposit),
        ]);
        return response()->json(['message' => 'Successfully', 'data' => $dd], 200);
    }

    public function updateInvestmentPlan(InvestmentPlan $investmentPlan,Request $request) {
        $request->validate([
            "name" => "required|string",
            "amount" => "required|string",
            "percent" => "required|string",
            "duration_in_days" => "required|string",
            "min_deposit" => "required|string",
            "max_deposit" => "required|string",
        ]);
        $data = $request->all();
        // $dd = $investmentPlan->update($request->all());
        $dd = InvestmentPlan::where("id", $investmentPlan->id)->first();
        $dd->update([
            "name" => $request->name,
            "amount" => $request->amount,
            "percent" => $request->percent,
            "duration_in_days" => $request->duration_in_days,
            "min_deposit" => trim($request->min_deposit),
            "max_deposit" => trim($request->max_deposit),
        ]);
        return response()->json(['message' => 'Successfully', 'data' => $investmentPlan], 200);
    }
}
