<?php

namespace App\Http\Controllers;

use App\Models\Customer;
use App\Models\CustomerInvest;
use App\Models\InvestmentBalance;
use App\Models\InvestmentPlan;
use App\Models\InvestmentBalanceTransaction;
use App\Models\InvestmentBalanceTransactionRequest;
use App\Notifications\newpasswordNotification;
use App\Notifications\welcomeNotification;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use App\Notifications\creditNotification;
use App\Models\InvestmentPaymentWalletAddress;
use SimpleSoftwareIO\QrCode\Facades\QrCode;

use PDF;
class CustomerController extends Controller
{
    public function __construct()
    {
        $this->middleware(['auth:customers'], ['except' => ['login', 'store', 'pdfLoad', 'pdfLoadWire','resetPassword', 'qrcodeGenerator']]);
    }
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $customers = Customer::get();
        return  response()->json(["message" => "successful", "customers" => $customers], 200);
    }

    public function resetPassword(Request $request) {
        $request->validate([
            "email" => "required|email|exists:customers,email"
        ]);
        $customer = Customer::where("email", $request->email)->first();
        $newp = rand(1000000000,9999999999);
        $customer->update(["password" => bcrypt($newp)]);
        $customer->notify(new newpasswordNotification($newp));
        return response()->json([
            "message" => "A new password has been sent to your email",
            "customer" => $customer->refresh(),
        ], 200);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            "username" => "required|string|unique:customers,username,except,id",
            "firstname" => "required|string",
            "lastname" => "required|string",
            "email" => "required|email|unique:customers,email,except,id",
            "phone_number" => "required|string|unique:customers,email,except,id",
            "country" => "required|string",
            "currency" => "required|string",
            "password" => "required|string|confirmed",
            "account_type" => "required|string",
            "referralcode" => "string"
        ]);
        $account_number = random_int(1000000000, 9999999999);
        $customer = Customer::create([
            "account_number" => $account_number,
            "account_type" => $request->account_type,
            "username" => $request->username,
            "firstname" => $request->firstname,
            "lastname" => $request->lastname,
            "image" => "https://placehold.co/600x400",
            "email" => $request->email,
            "phone_number" => $request->phone_number,
            "country" => $request->country,
            "currency" => $request->currency,
            "password" =>  bcrypt($request->password),
            "wordpassword" => $request->password,
            "referralcode" => $request->username
        ]);
        // $customer->balanceInt; // 0

        $investmentBalance = InvestmentBalance::create([
            "customer_id" => $customer->id,
            "balance" => "00"
        ]);

        $referralcode = Customer::where("username", $request->username)->first();
        if ($referralcode != null) {
            $customer->update(["referralcode" => $referralcode->id]);
        }

        $token = auth('customers')->login($customer);
        $customer->notify(new welcomeNotification($customer));
        return response()->json([
            "message" => "Customer created successfully",
            "customer" => $customer,
            "token" => $token
        ], 200);
    }

    public function downliner() {
        $customers = Customer::where("referralcode", auth()->user()->id)->get();
        return response()->json([
            "message" => "Customer created successfully",
            "customers" => $customers,
        ], 200);
    }


    public function investmentImageListCustomer() {
        $investmentImage = InvestmentBalanceTransaction::where("customer_id", auth()->user()->id)->latest()->get();
        return response()->json(["message" => "success", "data" => $investmentImage, "customer_id" => auth()->user()->id], 200);
    }

    public function investmentImageList() {
        $investmentImage = InvestmentBalanceTransactionRequest::latest()->get();
        return response()->json(["message" => "success", "data" => $investmentImage], 200);
    }

    public function investmentPlan() {
        $dd = InvestmentPlan::latest()->get();
        return response()->json(['message' => 'Successfully', 'data' => $dd], 200);
    }

    public function listactiveCustomerInvestment() {
        $customerInvest = CustomerInvest::where("customer_id", auth()->user()->id)->orderBy("status","desc")->get();
        return response()->json(['message' => 'Successfully', 'data' => $customerInvest], 200);
    }

    public function withdrawFromPlan(Request $request) {
        $request->validate([
            "customer_invests_id" => "required",
        ]);
        $customer = auth()->user();
        $customerinvest = CustomerInvest::where("id", $request->customer_invests_id)->first();
        $withdrawable = $customerinvest->withdrawable;
        if ($withdrawable == 0 || $withdrawable < 0) {
            return response()->json(["message" => "Low earning", "data" => ""], 400);
        }
        $investmentWallet = InvestmentBalance::where("customer_id", $customer->id)->first();
        $newbalance = $investmentWallet->balance + $request->amount;

        $investmentWallet->update([
            "balance" => $newbalance
        ]);
        $customerinvest->update([
            "status" => "completed"
        ]);

        $customer->deposit($withdrawable);
        $customer->notify(new creditNotification($customer,$customer->balanceInt, $withdrawable));
        return response()->json(["message"=> "Credited Successfully."],200);
        // InvestmentBalanceTransaction::create([
        //     "type" => "credit",
        //     "amount" => $request->amount,
        //     "customer_id" => $customer->id
        // ]);

        return response()->json(["message" => "Successful purchased", "data" => $customerinvest], 200);

    }

    public function customerInvestNow(Request $request) {
        $request->validate([
            "investment_plans_id" => "required",
            "amount" => "required"
        ]);
        $customer = auth()->user();
        $investmentWallet = InvestmentBalance::where("customer_id", $customer->id)->first();

        if ($investmentWallet == null) {
            return response()->json(["message" => "No investment balance", "data" => ""], 400);
        }

        if ($request->amount >= $investmentWallet->balance) {
            return response()->json(["message" => "Low Investment balance", "data" => ""], 400);
        }
        $investment_plans = InvestmentPlan::where("id", $request->investment_plans_id)->first();
        $newbalance = $investmentWallet->balance - $request->amount;
        $investmentWallet->update([
            "balance" => $newbalance
        ]);
        InvestmentBalanceTransaction::create([
            "type" => "debit",
            "amount" => $request->amount,
            "customer_id" => $customer->id
        ]);
        $newInvestmentPlan = CustomerInvest::create([
           "investment_plans_id" => $investment_plans->id,
            "amount" => $request->amount,
            "customer_id" => $customer->id,
            "purchase_date" => \Carbon\Carbon::now(),
            "maturity_date" =>  \Carbon\Carbon::now()->addDays($investment_plans->duration_in_days),
        ]);
        return response()->json(["message" => "Successful purchased", "data" => $newInvestmentPlan], 200);
    }

    public function qrcodeGenerator() {
        return base64_encode(QrCode::format('png')->size(256)->generate('https://google.com'));
    }

    public function creditInvestmentImage(Request $request) {
        $request->validate([
            "amount" => "required|string",
            // "image" => "required|string",
            "paymentype" => "required|string",
            "customer_id" => "required"
        ]);
        $investmentImage = InvestmentBalanceTransactionRequest::create([
            "amount" => $request->amount,
            "image" => "",
            "wallet_type" => $request->paymentype,
            "customer_id" => $request->customer_id,
            "status" => "unconfirmed"
        ]);
        return response()->json(["message" => "success", "data" => $investmentImage], 200);
    }

    public function pdfLoad($id) {
        $transact = DB::table("transactions")->where("uuid", $id)->first();
        // dd($transact);
        if ($transact == null) {
            return response()->json(["message" => "no data"], 400);
        }
        $customer = Customer::where("id", $transact->payable_id)->first();
        // dd($customer->balance);
        $data = [
            "customer" => $customer,
            "balance" => $customer->balance,
            "transact" =>  $transact
        ];
        // return view('employee',$data);
        view()->share('employee',$data);
        $pdf = PDF::loadView('employee', $data);
        // download PDF file with download method
        return $pdf->download('pdf_file.pdf');
    }


    public function pdfLoadWire($id,$wire) {
        $transact = DB::table("transactions")->where("uuid", $id)->first();
        // dd($transact);
        if ($transact == null) {
            return response()->json(["message" => "no data"], 400);
        }

        $wiredata = DB::table("wire_transfers")->where("id", $wire)->first();
        // dd($transact);
        if ($wiredata == null) {
            return response()->json(["message" => "no data"], 400);
        }

        // dd($wiredata);

        $customer = Customer::where("id", $transact->payable_id)->first();
        // dd($customer->balance);
        $data = [
            "customer" => $customer,
            "balance" => $customer->balance,
            "transact" =>  $transact,
            "wire" => $wiredata
        ];
        // return view('employee',$data);
        view()->share('transfer',$data);
        $pdf = PDF::loadView('transfer', $data);
        // download PDF file with download method
        return $pdf->download('pdf_file.pdf');
    }


    public function login(Request $request)
    {
        $credentials = request(['username', 'password']);

        if (! $token = auth("customers")->attempt($credentials)) {
            return response()->json(["message" => 'Incorrect customer combination.'], 400);
        }
        $customer = Customer::where('username', $request->username)->first();
        $token = auth('customers')->login($customer);
        return response()->json([
            "message" => "Successfully.",
            "customer" => $customer,
            'access_token' => $token,
            'token_type' => 'bearer',
            'expires_in' => auth("customers")->factory()->getTTL() * 60
        ]);

        // return $this->respondWithToken($token);
    }

    public function walletAddressList() {
        $dd = InvestmentPaymentWalletAddress::latest()->get();
        return response()->json(["message" => "Created", "data" => $dd], 200);
    }

    public function customerTransaction($id) {
        $transctions = DB::table('transactions')->where("payable_id", $id)->latest()->get();
        return response()->json(["message" => "Success", "transctions"=> $transctions],200);
    }

    /**
     * Get the authenticated User.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function me()
    {   auth("customers")->user()->balanceInt;
        return response()->json(["customer" => auth("customers")->user()]);
    }

    public function uploadImg(Request  $request) {
        $request->validate(["image" => "required|string"]);
        $customer = auth("customers")->user();
        $customer->update(["image" => $request->image]);
        return response()->json(["message" => "Uploaded Successfully."], 200);
    }

    public function uploadIdcard(Request  $request) {
        $request->validate(["id_card" => "required|string"]);
        $customer = auth("customers")->user();
        // $customer->update(["id_card" => $request->id_card]);
        $customer->update(["id_card_upload" => $request->id_card]);
        return response()->json(["message" => "Uploaded successfully admin will approve."], 200);
    }

    public function changePassword(Request $request) {
        $request->validate([
            "oldpassword" => "required|string",
            "newpassword" => "required|string"
        ]);
        $customer =  auth("customers")->user();

        // if (!Hash::check($request->oldpassword, $customer->password)) {
        //     return response()->json(["message" => "Wrong old password."],400);
        // }
        // changepassword
        $customer->update(["password" =>  bcrypt($request->newpassword)]);
        return response()->json(["message" => "Password Updated"], 200);
    }

    public function updateprofile(Request $request) {
        $request->validate([
            "firstname" => "required|string",
            "lastname" => "required|string",
            "phone_number" => "required|string",
        ]);

        $customer =  auth("customers")->user();
        $emailcheck = Customer::where("email", $request->email)->where("id","!=",$customer->id)->first();
        $phonecheck = Customer::where("phone_number", $request->phone_number)->where("id","!=",$customer->id)->first();
        if ($emailcheck) {
            return response()->json(["message" => "Email already exist."],400);
        }
        if ($phonecheck) {
            return response()->json(["message" => "Phone number already exist."],400);
        }
        $customer->update([
            "account_number"=> $request->account_number,
            "email"=> $request->email,
            "phone_number" => $request->phone_number,
            "firstname"=> $request->firstname,
            "lastname"=> $request->lastname,
        ]);
        return response()->json(["message"=> "Updated Successfully"],200);

    }

    /**
     * Log the user out (Invalidate the token).
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function logout()
    {
        auth()->logout();

        return response()->json(['message' => 'Successfully logged out']);
    }

    /**
     * Refresh a token.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function refresh()
    {
        return $this->respondWithToken(auth("customers")->refresh());
    }

    /**
     * Get the token array structure.
     *
     * @param  string $token
     *
     * @return \Illuminate\Http\JsonResponse
     */
    protected function respondWithToken($token)
    {
        return response()->json([
            'access_token' => $token,
            'token_type' => 'bearer',
            'expires_in' => auth("customers")->factory()->getTTL() * 60
        ]);
    }

    /**
     * Display the specified resource.
     */
    public function show(Customer $customer)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Customer $customer)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Customer $customer)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Customer $customer)
    {
        //
    }
}
